import allure
import pytest

from selenium import webdriver


def pytest_addoption(parser):
    parser.addoption(
        "--browser",
        action="store",
        default="firefox",
        help="Выбор браузера: firefox или chrome"
    )


@pytest.fixture(autouse=True)
def driver(request):
    browser_name = request.config.getoption("--browser")

    if browser_name.lower() == "chrome":
        options = webdriver.ChromeOptions()
        options.page_load_strategy = "eager"
        options.add_argument("--headless=new")
        options.add_argument("--no-sandbox")
        options.add_argument("--disable-dev-shm-usage")
        driver = webdriver.Chrome(options=options)
    elif browser_name.lower() == "firefox":
        options = webdriver.FirefoxOptions()
        options.page_load_strategy = "eager"
        options.add_argument("--headless")
        driver = webdriver.Firefox(options=options)
    else:
        raise ValueError(f"Неподдерживаемый браузер: {browser_name}")
    request.cls.driver = driver
    yield driver
    driver.quit()